#include <iostream>
#include <vector>
#include <cmath>
#include <map>
#include <tuple>
#include <numeric>

using namespace std;


struct Point {
    long long x, y;
    int index; 
};

pair<long long, long long> get_direction_vector(int direction) {
    if (direction == 0) return {0, 1};
    if (direction == 1) return {1, 0};
    if (direction == 2) return {0, -1};
    if (direction == 3) return {-1, 0};
    return {0, 0};
}


bool check_time_and_order(const Point& pi, const Point& pj, long long Dx, long long Dy) {
    
    long long delta_x = pj.x - pi.x;
    long long delta_y = pj.y - pi.y;
    
    long long t = -1; 
    if (Dx != 0) {
        if (delta_x % Dx != 0) return false;
        t = delta_x / Dx;
    } else {
        if (delta_x != 0) return false;
    }
    

    if (Dy != 0) {
        long long ty;
        if (delta_y % Dy != 0) return false;
        ty = delta_y / Dy;
        
        if (Dx != 0) {

            if (t != ty) return false;
        } else {

            t = ty;
        }
    } else {
        if (delta_y != 0) return false;
    }

    if (t == -1) return false;


    return t >= 1;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int N;
    if (!(cin >> N)) return 0;

    vector<Point> points(N);
    for (int i = 0; i < N; ++i) {
        cin >> points[i].x >> points[i].y;
        points[i].index = i;
    }

    long long total_hellos = 0;

    map<long long, vector<int>> groups[4][4]; 
    for (int i = 0; i < N; ++i) {
        for (int dir_i = 0; dir_i < 4; ++dir_i) {
            pair<long long, long long> v1 = get_direction_vector(dir_i);
            long long dx1 = v1.first;
            long long dy1 = v1.second;

            for (int dir_j = 0; dir_j < 4; ++dir_j) {
                pair<long long, long long> v2 = get_direction_vector(dir_j);
                long long dx2 = v2.first;
                long long dy2 = v2.second;

                long long Dx = dx1 - dx2;
                long long Dy = dy1 - dy2;

                long long I = Dy * points[i].x - Dx * points[i].y;

                groups[dir_i][dir_j][I].push_back(i);
            }
        }
    }

    for (int dir_i = 0; dir_i < 4; ++dir_i) {
        pair<long long, long long> v1 = get_direction_vector(dir_i);
        long long dx1 = v1.first;
        long long dy1 = v1.second;
        
        for (int dir_j = 0; dir_j < 4; ++dir_j) {
            pair<long long, long long> v2 = get_direction_vector(dir_j);
            long long dx2 = v2.first;
            long long dy2 = v2.second;

            long long Dx = dx1 - dx2;
            long long Dy = dy1 - dy2;

            for (const auto& pair : groups[dir_i][dir_j]) {
                const vector<int>& list = pair.second;

                for (size_t a = 0; a < list.size(); ++a) {
                    for (size_t b = a + 1; b < list.size(); ++b) {
                        
                        const Point& Pa = points[list[a]];
                        const Point& Pb = points[list[b]];

                        if (check_time_and_order(Pa, Pb, Dx, Dy)) {
                            total_hellos++;
                        }
                    }
                }
            }
        }
    }

    cout << total_hellos << endl;

    return 0;
}